####	ROAD TRAFFIC SIGNS
####	==================
####
####	by Sinanju
####
####	An Add-On for LFSLapper V5.926 and later
####	(but preferably v6.012+)
####
####
####	Install this file into ..\bin\default\includes
####	then open the addonsused.lpr file and paste the following line (without hashes)
####	include( "./signs.lpr");
####
#####################################################################################
# Ver 1.0 - 21 Dec 2012 - Initial Release
#####################################################################################

# Colour Codes:
# ^0 - black
# ^1 - red
# ^2 - green
# ^3 - yellow
# ^4 - blue
# ^5 - violet
# ^6 - cyan
# ^7 - white
# ^8 - no color (grey) (or leave text colour blank)


# Event triggered when lapper start
# =================================
CatchEvent OnLapperStart()

	### Set initial dialog coordinates & size for Traffic Signs ###
	GlobalVar $TSorigL; $TSorigL = 12;	# Left edge of sign / button / label
	GlobalVar $TSorigT; $TSorigT = 30;	# Top edge of sign / button / label            
  	
	### Set locations where Traffic Sign events occur ###	
	
	RegisterZoneAction( "AU1" , 26, -992, 2 , SE_NoEntry1,"" ); # No Entry sign	
	RegisterZoneAction( "AU1" , -8, -978, 2 , SE_NoEntry2,"" );	
	RegisterZoneAction( "AU1" , -79, -990, 2 , SE_GiveWay,"" );	# Give Way sign	
	RegisterZoneAction( "AU1" , 28, -973, 2 , SE_GiveWayGW,"" );	# Give Way sign with Give Way text under sign	
	RegisterZoneAction( "AU1" , -40, -939, 2 , SE_GiveWayStop,"" );	# Give Way sign with Stop text under sign	
	RegisterZoneAction( "AU1" , 38, -1013, 2 , SE_WarningSign1,"" ); # Blank Warning sign
	RegisterZoneAction( "AU1" , 42, -937, 2 , SE_WarningSignEM,"" ); # Warning sign with exclamation mark
	RegisterZoneAction( "AU1" , -62, -950, 2 , SE_WarningSignLFA,"" ); # Warning sign with exclamation mark and text (Low Flying Aircraft(	
	RegisterZoneAction( "AU1" , -91, -967, 2 , SE_WarningSignHD,"" ); # Warning sign with exclamation mark and text (Hidden Dip)
	RegisterZoneAction( "AU1" , -116, -981, 2 , SE_WarningSignTW,"" ); # Warning sign with exclamation mark and text (Two Way)
	RegisterZoneAction( "AU1" , -65, -1063, 2 , SE_WarningSignTWR,"" ); # Warning sign with exclamation mark and text (Two Way - reversed)
	RegisterZoneAction( "AU1" , -130, -1061, 2 , SE_WarningSignMR,"" ); # Warning sign with mini-roundabout sign
	RegisterZoneAction( "AU1" , 8, -1010, 2 , SE_WarningSignTLA,"" ); # Warning sign advising Traffic Lights Ahead             	
	RegisterZoneAction( "AU1" , -5, -1008, 2 , SE_StopSign,"" );	
  RegisterZoneAction( "AU1" , -155, -1007, 2 , SE_MustNotDo,"" ); # Blank circular must NOT do sign
  RegisterZoneAction( "AU1" , 2, -974, 2 , SE_MustNotDoMaxWidth,"" ); # Blank circular must NOT do sign
  RegisterZoneAction( "AU1" , 14, -916, 2 , SE_NoPedestrians,"" ); # No Pedestrians sign     
  RegisterZoneAction( "AU1" , -167, -1031, 2 , SE_SpeedSign10,"" );
  RegisterZoneAction( "AU1" , -167, -1031, 2 , SE_SpeedSign20,"" );    
	RegisterZoneAction( "AU1" , -150, -1037, 2 , SE_SpeedSign25,"" );
	RegisterZoneAction( "AU1" , -105, -1062, 2 , SE_SpeedSign30,"" );
  RegisterZoneAction( "AU1" , -6, -919, 2 , SE_SpeedSign40,"" );
  RegisterZoneAction( "AU1" , -45, -1064, 2 , SE_SpeedSign50,"" );  
  RegisterZoneAction( "AU1" , -49, -968, 2 , SE_SpeedSign60,"" );
  RegisterZoneAction( "AU1" , -70, -988, 2 , SE_SpeedSign70,"" );    
  RegisterZoneAction( "AU1" , -28, -943, 2 , SE_SpeedSign49mph,"" ); # Use for pit speed (in mph)	 
  RegisterZoneAction( "AU1" , -32, -948, 2 , SE_SpeedSign80kmh,"" ); # Use for pit speed (in kmh)  
EndCatchEvent
          

# Event triggered when Player spectates or disconnects (leaves race)
# ==================================================================
CatchEvent OnLeaveRace($userName)  # Player event
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs	
EndCatchEvent

################################################################################

# Sub-routines for above events

Sub SE_NoEntry1( $userName )
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs	
	
	openPrivButton( "ne_back",140,5,126,126,1,-1,64,"^1•"); # red background
	openPrivButton( "ne_slot1",160,65,25,13,1,-1,64,"^7|||||||||||||||||");
	openPrivButton( "ne_slot2",160,65,25,13,1,-1,64,"^7 ||||||||||||||||");
	openPrivButton( "ne_slot3",159,65,10,13,1,-1,64,"^7 |");	
	openPrivButton( "ne_text",163,68,18,8,1,-1,0,"^0NO ENTRY");  
EndSub

Sub SE_NoEntry2( $userName )
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs
	
	openPrivButton( "ne_back",140,5,126,126,1,-1,64,"^1•"); # red background
	openPrivButton( "ne_slot1",160,65,25,13,1,-1,64,"^7|||||||||||||||||");
	openPrivButton( "ne_slot2",160,65,25,13,1,-1,64,"^7 ||||||||||||||||");
	openPrivButton( "ne_slot3",159,65,10,13,1,-1,64,"^7 |");	  
EndSub
 
Sub SE_GiveWay($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs	
          
 	openPrivButton( "gw_back",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");   
 	openPrivButton( "gw_centre",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "gw_front",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "gw_white",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "gw_whiter",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");       	
  openPrivButton( "gw_line1",$TSorigL+8,$TSorigT,22,8,4,-1,0,"^1==============");
  openPrivButton( "gw_line2a",$TSorigL,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line2b",$TSorigL+18,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line3a",$TSorigL+1,$TSorigT+7,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line3b",$TSorigL+17,$TSorigT+7,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line4a",$TSorigL+2,$TSorigT+10,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line4b",$TSorigL+16,$TSorigT+10,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line5a",$TSorigL+3,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line5b",$TSorigL+15,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line6a",$TSorigL+4,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line6b",$TSorigL+14,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line7a",$TSorigL+5,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line7b",$TSorigL+13,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line8a",$TSorigL+6,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line8b",$TSorigL+12,$TSorigT+22,20,7,4,-1,0,"^1II"); 
  openPrivButton( "gw_line9a",$TSorigL+7,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line9b",$TSorigL+11,$TSorigT+25,20,7,4,-1,0,"^1II");  
  openPrivButton( "gw_line10a",$TSorigL+8,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line10b",$TSorigL+10,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line11",$TSorigL+9,$TSorigT+31,20,7,4,-1,0,"^1I");  
	openPrivButton( "gw_textg",$TSorigL+6,$TSorigT+4,26,14,4,-1,0,"^0GIVE");
  openPrivButton( "gw_textw",$TSorigL+11,$TSorigT+15,16,8,5,-1,0,"^0WAY");    
EndSub 
 
Sub SE_GiveWayGW($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs	
          
 	openPrivButton( "gw_back",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");   
 	openPrivButton( "gw_centre",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "gw_front",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "gw_white",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "gw_whiter",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");       	
  openPrivButton( "gw_line1",$TSorigL+8,$TSorigT,22,8,4,-1,0,"^1==============");
  openPrivButton( "gw_line2a",$TSorigL,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line2b",$TSorigL+18,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line3a",$TSorigL+1,$TSorigT+7,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line3b",$TSorigL+17,$TSorigT+7,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line4a",$TSorigL+2,$TSorigT+10,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line4b",$TSorigL+16,$TSorigT+10,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line5a",$TSorigL+3,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line5b",$TSorigL+15,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line6a",$TSorigL+4,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line6b",$TSorigL+14,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line7a",$TSorigL+5,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line7b",$TSorigL+13,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line8a",$TSorigL+6,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line8b",$TSorigL+12,$TSorigT+22,20,7,4,-1,0,"^1II"); 
  openPrivButton( "gw_line9a",$TSorigL+7,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line9b",$TSorigL+11,$TSorigT+25,20,7,4,-1,0,"^1II");  
  openPrivButton( "gw_line10a",$TSorigL+8,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line10b",$TSorigL+10,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line11",$TSorigL+9,$TSorigT+31,20,7,4,-1,0,"^1I");  
 	openPrivButton( "gw_textbackdark",$TSorigL+8,$TSorigT+40,22,14,2,-1,32,"");
 	openPrivButton( "gw_textbackdarkring",$TSorigL+8,$TSorigT+40,22,14,2,-1,32,""); 	
  openPrivButton( "gw_textbacklight",$TSorigL+9,$TSorigT+41,20,12,2,-1,16,"");
  openPrivButton( "gw_textbacklight2",$TSorigL+9,$TSorigT+41,20,12,2,-1,16,"");    
	openPrivButton( "gw_text",$TSorigL+10,$TSorigT+41,18,6,5,-1,0,"^0GIVE WAY%nl%^050 Yards");      
EndSub
 
 Sub SE_GiveWayStop($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs	
          
 	openPrivButton( "gw_back",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");   
 	openPrivButton( "gw_centre",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "gw_front",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "gw_white",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "gw_whiter",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");       	
  openPrivButton( "gw_line1",$TSorigL+8,$TSorigT,22,8,4,-1,0,"^1==============");
  openPrivButton( "gw_line2a",$TSorigL,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line2b",$TSorigL+18,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line3a",$TSorigL+1,$TSorigT+7,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line3b",$TSorigL+17,$TSorigT+7,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line4a",$TSorigL+2,$TSorigT+10,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line4b",$TSorigL+16,$TSorigT+10,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line5a",$TSorigL+3,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line5b",$TSorigL+15,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line6a",$TSorigL+4,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line6b",$TSorigL+14,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line7a",$TSorigL+5,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line7b",$TSorigL+13,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line8a",$TSorigL+6,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line8b",$TSorigL+12,$TSorigT+22,20,7,4,-1,0,"^1II"); 
  openPrivButton( "gw_line9a",$TSorigL+7,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line9b",$TSorigL+11,$TSorigT+25,20,7,4,-1,0,"^1II");  
  openPrivButton( "gw_line10a",$TSorigL+8,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line10b",$TSorigL+10,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "gw_line11",$TSorigL+9,$TSorigT+31,20,7,4,-1,0,"^1I");  
 	openPrivButton( "gw_textbackdark",$TSorigL+8,$TSorigT+40,22,14,2,-1,32,"");
 	openPrivButton( "gw_textbackdarkring",$TSorigL+8,$TSorigT+40,22,14,2,-1,32,""); 	
  openPrivButton( "gw_textbacklight",$TSorigL+9,$TSorigT+41,20,12,2,-1,16,"");
  openPrivButton( "gw_textbacklight2",$TSorigL+9,$TSorigT+41,20,12,2,-1,16,"");    
	openPrivButton( "gw_text",$TSorigL+10,$TSorigT+41,18,6,5,-1,0,"^0STOP%nl%^0100 Yards");      
EndSub

Sub SE_WarningSign1($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs		
             
 	openPrivButton( "ws_back",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");   
 	openPrivButton( "ws_centre",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_front",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_white",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_whiter",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");       	
  openPrivButton( "ws_line1",$TSorigL+8,$TSorigT+31,22,8,4,-1,0,"^1==============");
  openPrivButton( "ws_line2a",$TSorigL,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line2b",$TSorigL+18,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line3a",$TSorigL+1,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line3b",$TSorigL+17,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line4a",$TSorigL+2,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line4b",$TSorigL+16,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line5a",$TSorigL+3,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line5b",$TSorigL+15,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line6a",$TSorigL+4,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line6b",$TSorigL+14,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line7a",$TSorigL+5,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line7b",$TSorigL+13,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line8a",$TSorigL+6,$TSorigT+10,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line8b",$TSorigL+12,$TSorigT+10,20,7,4,-1,0,"^1II"); 
  openPrivButton( "ws_line9a",$TSorigL+7,$TSorigT+7,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line9b",$TSorigL+11,$TSorigT+7,20,7,4,-1,0,"^1II");  
  openPrivButton( "ws_line10a",$TSorigL+8,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line10b",$TSorigL+10,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line11",$TSorigL+9,$TSorigT+1,20,7,4,-1,0,"^1I");   
EndSub 

Sub SE_WarningSignEM($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs		
             
 	openPrivButton( "ws_back",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");   
 	openPrivButton( "ws_centre",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_front",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_white",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_whiter",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");       	
  openPrivButton( "ws_line1",$TSorigL+8,$TSorigT+31,22,8,4,-1,0,"^1==============");
  openPrivButton( "ws_line2a",$TSorigL,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line2b",$TSorigL+18,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line3a",$TSorigL+1,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line3b",$TSorigL+17,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line4a",$TSorigL+2,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line4b",$TSorigL+16,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line5a",$TSorigL+3,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line5b",$TSorigL+15,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line6a",$TSorigL+4,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line6b",$TSorigL+14,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line7a",$TSorigL+5,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line7b",$TSorigL+13,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line8a",$TSorigL+6,$TSorigT+10,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line8b",$TSorigL+12,$TSorigT+10,20,7,4,-1,0,"^1II"); 
  openPrivButton( "ws_line9a",$TSorigL+7,$TSorigT+7,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line9b",$TSorigL+11,$TSorigT+7,20,7,4,-1,0,"^1II");  
  openPrivButton( "ws_line10a",$TSorigL+8,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line10b",$TSorigL+10,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line11",$TSorigL+9,$TSorigT+1,20,7,4,-1,0,"^1I");
  openPrivButton( "ws_message",$TSorigL+9,$TSorigT+4,20,39,4,-1,0,"^0!");     
EndSub 

Sub SE_WarningSignLFA($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs		
             
 	openPrivButton( "ws_back",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");   
 	openPrivButton( "ws_centre",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_front",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_white",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_whiter",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");       	
  openPrivButton( "ws_line1",$TSorigL+8,$TSorigT+31,22,8,4,-1,0,"^1==============");
  openPrivButton( "ws_line2a",$TSorigL,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line2b",$TSorigL+18,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line3a",$TSorigL+1,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line3b",$TSorigL+17,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line4a",$TSorigL+2,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line4b",$TSorigL+16,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line5a",$TSorigL+3,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line5b",$TSorigL+15,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line6a",$TSorigL+4,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line6b",$TSorigL+14,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line7a",$TSorigL+5,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line7b",$TSorigL+13,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line8a",$TSorigL+6,$TSorigT+10,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line8b",$TSorigL+12,$TSorigT+10,20,7,4,-1,0,"^1II"); 
  openPrivButton( "ws_line9a",$TSorigL+7,$TSorigT+7,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line9b",$TSorigL+11,$TSorigT+7,20,7,4,-1,0,"^1II");  
  openPrivButton( "ws_line10a",$TSorigL+8,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line10b",$TSorigL+10,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line11",$TSorigL+9,$TSorigT+1,20,7,4,-1,0,"^1I");
  openPrivButton( "ws_message",$TSorigL+9,$TSorigT+4,20,39,4,-1,0,"^0!");
 	openPrivButton( "ws_textbackdark",$TSorigL+8,$TSorigT+40,22,14,2,-1,32,"");
 	openPrivButton( "ws_textbackdarkring",$TSorigL+8,$TSorigT+40,22,14,2,-1,32,""); 	
  openPrivButton( "ws_textbacklight",$TSorigL+9,$TSorigT+41,20,12,2,-1,16,"");
  openPrivButton( "ws_textbacklight2",$TSorigL+9,$TSorigT+41,20,12,2,-1,16,"");    
	openPrivButton( "ws_text",$TSorigL+10,$TSorigT+41,18,6,5,-1,0,"^0Low Flying%nl%^0Aircraft");  
EndSub

Sub SE_WarningSignHD($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs		
             
 	openPrivButton( "ws_back",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");   
 	openPrivButton( "ws_centre",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_front",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_white",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_whiter",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");       	
  openPrivButton( "ws_line1",$TSorigL+8,$TSorigT+31,22,8,4,-1,0,"^1==============");
  openPrivButton( "ws_line2a",$TSorigL,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line2b",$TSorigL+18,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line3a",$TSorigL+1,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line3b",$TSorigL+17,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line4a",$TSorigL+2,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line4b",$TSorigL+16,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line5a",$TSorigL+3,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line5b",$TSorigL+15,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line6a",$TSorigL+4,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line6b",$TSorigL+14,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line7a",$TSorigL+5,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line7b",$TSorigL+13,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line8a",$TSorigL+6,$TSorigT+10,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line8b",$TSorigL+12,$TSorigT+10,20,7,4,-1,0,"^1II"); 
  openPrivButton( "ws_line9a",$TSorigL+7,$TSorigT+7,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line9b",$TSorigL+11,$TSorigT+7,20,7,4,-1,0,"^1II");  
  openPrivButton( "ws_line10a",$TSorigL+8,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line10b",$TSorigL+10,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line11",$TSorigL+9,$TSorigT+1,20,7,4,-1,0,"^1I");
  openPrivButton( "ws_message",$TSorigL+9,$TSorigT+4,20,39,4,-1,0,"^0!");
 	openPrivButton( "ws_textbackdark",$TSorigL+8,$TSorigT+40,22,14,2,-1,32,"");
 	openPrivButton( "ws_textbackdarkring",$TSorigL+8,$TSorigT+40,22,14,2,-1,32,""); 	
  openPrivButton( "ws_textbacklight",$TSorigL+9,$TSorigT+41,20,12,2,-1,16,"");
  openPrivButton( "ws_textbacklight2",$TSorigL+9,$TSorigT+41,20,12,2,-1,16,"");    
	openPrivButton( "ws_text",$TSorigL+10,$TSorigT+41,18,6,5,-1,0,"^0Hidden%nl%^0Dip");  
EndSub


Sub SE_WarningSignTW($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs		
             
 	openPrivButton( "ws_back",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");   
 	openPrivButton( "ws_centre",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_front",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_white",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_whiter",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");       	
  openPrivButton( "ws_line1",$TSorigL+8,$TSorigT+31,22,8,4,-1,0,"^1==============");
  openPrivButton( "ws_line2a",$TSorigL,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line2b",$TSorigL+18,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line3a",$TSorigL+1,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line3b",$TSorigL+17,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line4a",$TSorigL+2,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line4b",$TSorigL+16,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line5a",$TSorigL+3,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line5b",$TSorigL+15,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line6a",$TSorigL+4,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line6b",$TSorigL+14,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line7a",$TSorigL+5,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line7b",$TSorigL+13,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line8a",$TSorigL+6,$TSorigT+10,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line8b",$TSorigL+12,$TSorigT+10,20,7,4,-1,0,"^1II"); 
  openPrivButton( "ws_line9a",$TSorigL+7,$TSorigT+7,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line9b",$TSorigL+11,$TSorigT+7,20,7,4,-1,0,"^1II");  
  openPrivButton( "ws_line10a",$TSorigL+8,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line10b",$TSorigL+10,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line11",$TSorigL+9,$TSorigT+1,20,7,4,-1,0,"^1I");
  openPrivButton( "ws_message1",$TSorigL+13,$TSorigT+6,12,30,4,-1,0,"^0^| |");
  openPrivButton( "ws_message2",$TSorigL+12,$TSorigT+11,12,12,4,-1,0,"^0A");   
  openPrivButton( "ws_message3",$TSorigL+16,$TSorigT+22,8,11,4,-1,0,"^0V");
 
EndSub

Sub SE_WarningSignTWR($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs		
             
 	openPrivButton( "ws_back",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");   
 	openPrivButton( "ws_centre",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_front",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_white",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_whiter",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");       	
  openPrivButton( "ws_line1",$TSorigL+8,$TSorigT+31,22,8,4,-1,0,"^1==============");
  openPrivButton( "ws_line2a",$TSorigL,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line2b",$TSorigL+18,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line3a",$TSorigL+1,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line3b",$TSorigL+17,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line4a",$TSorigL+2,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line4b",$TSorigL+16,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line5a",$TSorigL+3,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line5b",$TSorigL+15,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line6a",$TSorigL+4,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line6b",$TSorigL+14,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line7a",$TSorigL+5,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line7b",$TSorigL+13,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line8a",$TSorigL+6,$TSorigT+10,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line8b",$TSorigL+12,$TSorigT+10,20,7,4,-1,0,"^1II"); 
  openPrivButton( "ws_line9a",$TSorigL+7,$TSorigT+7,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line9b",$TSorigL+11,$TSorigT+7,20,7,4,-1,0,"^1II");  
  openPrivButton( "ws_line10a",$TSorigL+8,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line10b",$TSorigL+10,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line11",$TSorigL+9,$TSorigT+1,20,7,4,-1,0,"^1I");
  openPrivButton( "ws_message1",$TSorigL+13,$TSorigT+6,12,30,4,-1,0,"^0^| |");
  openPrivButton( "ws_message2",$TSorigL+12,$TSorigT+22,12,12,4,-1,0,"^0v");   
  openPrivButton( "ws_message3",$TSorigL+16,$TSorigT+11,8,11,4,-1,0,"^0A");
EndSub

Sub SE_WarningSignMR($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs		
             
 	openPrivButton( "ws_back",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");   
 	openPrivButton( "ws_centre",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_front",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_white",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_whiter",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");       	
  openPrivButton( "ws_line1",$TSorigL+8,$TSorigT+31,22,8,4,-1,0,"^1==============");
  openPrivButton( "ws_line2a",$TSorigL,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line2b",$TSorigL+18,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line3a",$TSorigL+1,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line3b",$TSorigL+17,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line4a",$TSorigL+2,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line4b",$TSorigL+16,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line5a",$TSorigL+3,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line5b",$TSorigL+15,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line6a",$TSorigL+4,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line6b",$TSorigL+14,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line7a",$TSorigL+5,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line7b",$TSorigL+13,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line8a",$TSorigL+6,$TSorigT+10,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line8b",$TSorigL+12,$TSorigT+10,20,7,4,-1,0,"^1II"); 
  openPrivButton( "ws_line9a",$TSorigL+7,$TSorigT+7,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line9b",$TSorigL+11,$TSorigT+7,20,7,4,-1,0,"^1II");  
  openPrivButton( "ws_line10a",$TSorigL+8,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line10b",$TSorigL+10,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line11",$TSorigL+9,$TSorigT+1,20,7,4,-1,0,"^1I");  
	openPrivButton( "ws_circleback",$TSorigL+5,$TSorigT-4,56,56,1,-1,64,"^0•"); # black background  
	openPrivButton( "ws_circlefront",$TSorigL+9,$TSorigT+5,39,39,1,-1,64,"^8•"); # gray foreground   
  openPrivButton( "ws_toparrow",$TSorigL,$TSorigT+12,38,14,1,-1,0,"^8>");
  openPrivButton( "ws_leftarrow",$TSorigL-3,$TSorigT+24,38,14,1,-1,0,"^8<");
  openPrivButton( "ws_rightarrow",$TSorigL+2,$TSorigT+23,38,14,1,-1,0,"^8<");            
EndSub


Sub SE_WarningSignTLA($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs		
             
 	openPrivButton( "ws_back",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");   
 	openPrivButton( "ws_centre",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_front",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_white",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");
 	openPrivButton( "ws_whiter",$TSorigL+8,$TSorigT+1,22,38,4,-1,16,"");       	
  openPrivButton( "ws_line1",$TSorigL+8,$TSorigT+31,22,8,4,-1,0,"^1==============");
  openPrivButton( "ws_line2a",$TSorigL,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line2b",$TSorigL+18,$TSorigT+28,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line3a",$TSorigL+1,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line3b",$TSorigL+17,$TSorigT+25,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line4a",$TSorigL+2,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line4b",$TSorigL+16,$TSorigT+22,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line5a",$TSorigL+3,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line5b",$TSorigL+15,$TSorigT+19,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line6a",$TSorigL+4,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line6b",$TSorigL+14,$TSorigT+16,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line7a",$TSorigL+5,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line7b",$TSorigL+13,$TSorigT+13,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line8a",$TSorigL+6,$TSorigT+10,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line8b",$TSorigL+12,$TSorigT+10,20,7,4,-1,0,"^1II"); 
  openPrivButton( "ws_line9a",$TSorigL+7,$TSorigT+7,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line9b",$TSorigL+11,$TSorigT+7,20,7,4,-1,0,"^1II");  
  openPrivButton( "ws_line10a",$TSorigL+8,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line10b",$TSorigL+10,$TSorigT+4,20,7,4,-1,0,"^1II");
  openPrivButton( "ws_line11",$TSorigL+9,$TSorigT+1,20,7,4,-1,0,"^1I");
 	openPrivButton( "ws_textbackdark",$TSorigL+17,$TSorigT+14,4,19,2,-1,32,"");
 	openPrivButton( "ws_textbackdarkring",$TSorigL+17,$TSorigT+14,4,19,2,-1,32,"");   
 	openPrivButton( "ws_textbackdarkring2",$TSorigL+17,$TSorigT+14,4,19,2,-1,32,"");
 	openPrivButton( "ws_circlered",$TSorigL+14,$TSorigT+7,20,20,1,-1,64,"^1•"); # red circle 
	openPrivButton( "ws_circleyellow",$TSorigL+14,$TSorigT+13,20,20,1,-1,64,"^3•"); # yellow circle  
	openPrivButton( "ws_circlegreen",$TSorigL+14,$TSorigT+19,20,20,1,-1,64,"^2•"); # green circle            
EndSub
  
Sub SE_StopSign($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs	 
	openPrivButton( "sts_back",0,5,126,126,1,-1,64,"^1•"); # red background
	openPrivButton( "sts_text",7,60,50,24,1,-1,0,"^7STOP"); # white text   
EndSub

Sub SE_SpeedSign10($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs	  
	openPrivButton( "ss_back",0,5,126,126,1,-1,64,"^1•"); # red background
	openPrivButton( "ss_front",6,19,101,101,1,-1,64,"^7•"); # white foreground
	openPrivButton( "ss_text",6,58,50,30,1,-1,0,"^010"); # black   
EndSub

Sub SE_SpeedSign20($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs	  
	openPrivButton( "ss_back",0,5,126,126,1,-1,64,"^1•"); # red background
	openPrivButton( "ss_front",6,19,101,101,1,-1,64,"^7•"); # white foreground
	openPrivButton( "ss_text",6,58,50,30,1,-1,0,"^020"); # black   
EndSub 

Sub SE_SpeedSign25($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs	   
	openPrivButton( "ss_back",0,5,126,126,1,-1,64,"^1•"); # red background
	openPrivButton( "ss_front",6,19,101,101,1,-1,64,"^7•"); # white foreground
	openPrivButton( "ss_text",6,58,50,30,1,-1,0,"^025"); # black   
EndSub 

Sub SE_SpeedSign30($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs       
	openPrivButton( "ss_back",0,5,126,126,1,-1,64,"^1•"); # red background
	openPrivButton( "ss_front",6,19,101,101,1,-1,64,"^7•"); # white foreground
	openPrivButton( "ss_text",6,58,50,30,1,-1,0,"^030"); # black   
EndSub 

Sub SE_SpeedSign40($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs  
	openPrivButton( "ss_back",0,5,126,126,1,-1,64,"^1•"); # red background
	openPrivButton( "ss_front",6,19,101,101,1,-1,64,"^7•"); # white foreground
	openPrivButton( "ss_text",6,58,50,30,1,-1,0,"^040"); # black   
EndSub

Sub SE_SpeedSign50($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs  
	openPrivButton( "ss_back",0,5,126,126,1,-1,64,"^1•"); # red background
	openPrivButton( "ss_front",6,19,101,101,1,-1,64,"^7•"); # white foreground
	openPrivButton( "ss_text",6,58,50,30,1,-1,0,"^050"); # black   
EndSub

Sub SE_SpeedSign60($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs  
	openPrivButton( "ss_back",0,5,126,126,1,-1,64,"^1•"); # red background
	openPrivButton( "ss_front",6,19,101,101,1,-1,64,"^7•"); # white foreground
	openPrivButton( "ss_text",6,58,50,30,1,-1,0,"^060"); # black   
EndSub

Sub SE_SpeedSign70($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs  
	openPrivButton( "ss_back",0,5,126,126,1,-1,64,"^1•"); # red background
	openPrivButton( "ss_front",6,19,101,101,1,-1,64,"^7•"); # white foreground
	openPrivButton( "ss_text",6,58,50,30,1,-1,0,"^070"); # black   
EndSub

Sub SE_SpeedSign49mph($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs
	openPrivButton( "ss_back49",123,12,126,126,1,-1,64,"^1•"); # red background
	openPrivButton( "ss_front49",129,26,101,101,1,-1,64,"^7•"); # white foreground
	openPrivButton( "ss_text49",129,65,50,30,1,-1,0,"^049"); # black
	openPrivButton( "ss_unitmph",129,87,50,5,1,-1,0,"^0mph");     
EndSub

Sub SE_SpeedSign80kmh($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs
	openPrivButton( "ss_back80",123,52,126,126,1,-1,64,"^1•"); # red background
  openPrivButton( "ss_front80",129,66,101,101,1,-1,64,"^7•"); # white foreground
	openPrivButton( "ss_text80",129,105,50,30,1,-1,0,"^080"); # black
	openPrivButton( "ss_unitkph",129,127,50,5,1,-1,0,"^0km/h");     
EndSub

Sub SE_MustNotDo($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs	  	       
	openPrivButton( "msd_back",0,5,126,126,1,-1,64,"^1•"); # red background
	openPrivButton( "msd_front",6,19,101,101,1,-1,64,"^7•"); # white foreground   
EndSub 


Sub SE_MustNotDoMaxWidth($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs	  	       
	openPrivButton( "msd_back",0,5,126,126,1,-1,64,"^1•"); # red background
	openPrivButton( "msd_front",6,19,101,101,1,-1,64,"^7•"); # white foreground
  openPrivButton( "msd_text>",0,67,50,12,1,-1,0,"^0>"); # black
  openPrivButton( "msd_text<",12,67,50,12,1,-1,0,"^0<"); # black
  openPrivButton( "msd_textmetreswhole",11,60,34,13,1,-1,0,"^02."); # black
  openPrivButton( "msd_textmetresfraction",16,62,34,10,1,-1,0,"^00 m"); # black  
  openPrivButton( "msd_textimperial",14,74,35,11,1,-1,0,"^06'-6''"); # black  
     
EndSub 


Sub SE_NoPedestrians($userName)
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ne_*"); # close no entry signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "gw_*"); # close give way signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ws_*"); # close warning signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "ss_*"); # close speed signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "sts_*"); # close stop signs
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "msd_*"); # close mustnotdo signs	  	       
	openPrivButton( "msd_back",0,5,126,126,1,-1,64,"^1•"); # red background
	openPrivButton( "msd_front",6,19,101,101,1,-1,64,"^7•"); # white foreground
  
 	openPrivButton( "msd_head",$TSorigL+15,$TSorigT+25,16,16,1,-1,64,"^0•"); # head
 	openPrivButton( "msd_body",$TSorigL+14,$TSorigT+25,12,27,1,-1,64,"^0|"); # body
  openPrivButton( "msd_arms",$TSorigL+11,$TSorigT+27,50,14,1,-1,64,"^0____"); # arms
  
  openPrivButton( "msd_legs",$TSorigL+8,$TSorigT+35,22,22,4,-1,0,"^0A "); # legs     
EndSub


Lang "EN"


EndLang